* SECTION 7: Barriers to Switching
* MARY-ALICE DOYLE
* LAST EDITED: 02 October 2018

*********
* SETUP
*********
*cd [specify filepath for working directory]
do ".\Stata files\Regression setup.do"
drop if ccown==0
set more off



***********************
* TABLE 8: Loss-making respondents
***********************
recode q7b -2 =.
* Col 1: each group as a share of loss-making cardholders
tablecol notswitching idtag if idtag==1 [pw=w1], colpct
quietly: tabout notswitching if idtag==1 [iw=w1] using ".\Excel output\7 descriptives.xls", replace c(col)
* Cols 2, 3, 5 (median NB, interquartile range and median annual fee)
quietly: tabout notswitching if idtag==1 [aw=w1] using ".\Excel output\7 descriptives.xls", append sum c(median netbenefit1111 p25 netbenefit1111 p75 netbenefit1111 median annualfee)
* Col 6 (median interst rate IF paid interest)
quietly: tabout notswitching if idtag==1 & q7b==1 & ccmainrate>=0 [aw=w1] using ".\Excel output\7 descriptives.xls", append sum c(median ccmainrate) f(4)
* Col 4: Whether considered switching cards in the past year
quietly: tabout notswitching if idtag==1 [aw=w1] using ".\Excel output\7 descriptives.xls", append sum c(mean considered) f(4)
gen notconsidered = 0 
replace notconsidered = 1 if notswitching == 0
label var notconsidered "did not consider switching, potential behavioural reason"
 
 recode q8g -1=2
 label define q8g 0 "Netural (0)" 1 "Better off (1)" 2 "Worse off (2)" 4 "Not sure (4)", replace
 label values q8g q8g
 
*******************
* Regressions in Appendix Table E3
*******************
* Probit MEs for impact of gain/loss and demographics on probabiliy of considering switching 
probit considered i.gain i.loss i.hhincq  if idtag==1  [pw=w1], vce(robust)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 appendix E consider.xls", replace  dec(2)
probit considered i.gain i.loss bankbranches i.hhincq  i.q8g i.agebin i.empstatcons i.educat2 i.deposit i.ccnum i.type c.ccmainrate i.ccmaintype if idtag==1  [pw=w1], vce(robust)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 Appendix E consider.xls",  dec(2)
probit considered i.gain i.loss bankbranches i.hhincq##i.q8g i.agebin i.empstatcons i.educat2 i.deposit i.ccnum i.type c.ccmainrate i.ccmaintype if idtag==1  [pw=w1], vce(robust)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 Appendix E consider.xls",  dec(2)


***************
* Figure 13: Effect of Perceived Loss on Probability of Considering Switching, by Income
***************
* marginal effects for graph, same as col 3 from appendix E table
probit considered i.gain i.loss bankbranches i.hhincq##i.q8g i.agebin i.empstatcons i.educat2 i.deposit i.ccnum i.type c.ccmainrate i.ccmaintype if idtag==1  [pw=w1], vce(robust)

margins 2.q8g, at(hhincq==1)
margins 2.q8g, at(hhincq==2)
margins 2.q8g, at(hhincq==3)
margins 2.q8g, at(hhincq==4)




*********
* TABLE E4
*********

* probit ME of whether actually switched cards
probit switched i.gain i.loss i.hhincq if idtag==1  [pw=w1], vce(robust)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 appendix E switched.xls", replace dec(2)
probit switched i.gain i.loss bankbranches i.hhincq i.q8g i.agebin i.empstatcons i.educat2 i.deposit i.ccnum i.type c.ccmainrate i.ccmaintype if idtag==1  [pw=w1], vce(robust)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 appendix E switched.xls",  dec(2)

*******
** In-text references
*******
*  7 1/2  per cent of cardholders reported having switched cards
tablecol switched idtag if idtag==1 & ccown==1 [pw=w1], colpct row
* the difference is not statisically significant
reg switched loss if idtag==1 & ccown==1 [pw=w1]


* Here I re-calculate the 'optimal' net benefit, so that I can report in text the 
// loss relative to 'optimal' for respondents in the 'potential behavioural' group
//as defined in table 8
* 'relative to their optimal card, these respondents made a median loss of $230
quietly {
* loss relative to optimal card by reason for not switching
drop rewards_annualval netpmtfunction ifp_potential ifp_value netborrowingvalue interest_paid
	drop if ccmainfee>=1000
* ^ drop 13 respondents whose annual fee was above $1000. They mean bias net benefit estimates downwards by a lot, but these respondents likely accrue other, non-rewards-points benefits that are not included in these calculations (eg free flights or whatevs). 

* Own main card 
gen fee0 = ccmainfee if ccmainfee!=-5
replace fee0 = annualfee_d*fee0 if fee0>=0
* ^ for main cc, we incorporate information in discounted fees, but for alternatives, we assume no discount.

gen rate0 = ccmainrate if ccmainrate!=-5
gen days0 = ccmainday if ccmainday!=-5
gen rewards0 = ccmainrebate if !inlist(ccmainrebate,-5,-1)
replace rewards0 = 0 if ccmainrebate==-1

* Card 218 -
gen fee1 = 0
gen rate1=11.5
gen days1 = 55
gen rewards1 = 0

* Card 2 - 
gen fee2=0
gen rate2=14.99
gen days2=55
gen rewards2=0.740740741

* Card 91 - 
gen fee3=0
gen rate3=19.99
gen days3=62
gen rewards3=0.25

* Card 143 - 
gen fee4=0
gen rate4=22.74
gen days4=62
gen rewards4=0.761614623

* Card 107 - 
gen fee5=30
gen rate5=10.49
gen days5=55
gen rewards5=0

* Card 188 - 
gen fee6=36
gen rate6=7.99
gen days6=55
gen rewards6=0

* Card 192 - 
gen fee7=39
gen rate7=13.2
gen days7=55
gen rewards7=0.666666667

* Card 89 - 
gen fee8=49
gen rate8=12.99
gen days8=62
gen rewards8=0

* Card 40 - 
gen fee9=49
gen rate9=11.99
gen days9=55
gen rewards9=0.4

* Card 90 - 
gen fee10=49
gen rate10=19.99
gen days10=62
gen rewards10=1

* Card 94 - 
gen fee11=59
gen rate11=20.24
gen days11=55
gen rewards11=0.75

* Card 24 - 
gen fee12=95
gen rate12=18.79
gen days12=55
gen rewards12=0.899887514

* Card 41 - 
gen fee13=129
gen rate13=18.49
gen days13=55
gen rewards13=0.8

* Card 104 - 
gen fee14=249
gen rate14=20.24
gen days14=55
gen rewards14=1.25

* Card 248 -
gen fee15=250
gen rate15=19.99
gen days15=45
gen rewards15=0.903614458

* Card 15 - 
gen fee16=295
gen rate16=19.99
gen days16=55
gen rewards16=0.903614458

* Card 96 - 
gen fee17=349
gen rate17=20.24
gen days17=55
gen rewards17=1.5

* Card 112 - 
gen fee18=389
gen rate18=42.57608868
gen days18=44
gen rewards18=1.675977654



forvalues i = 0/18 {

		* Step 1
		******************
		gen rewards_annualval = 0
		replace rewards_annualval = rewards`i'/100* annualspend  if annualspend!=. 
		replace rewards_annualval = . if annualspend==.
				
		* $ value of annual fee

		* Step 2.5: Net value of payment function
		******************
		gen netpmtfunction = rewards_annualval - fee`i'

		* Step 3: Interest-free period
		*******************
		* Value of interest free period - assuming balance is accrued in the middle of the month (day 15)
		gen ifp_potential = annualspend * alt_ir *(days`i'-15)/365 
		label var ifp_potential "Value of IFP if respondent pays off on the due date"
		
		gen ifp_value = ifp_potential * ifp_used
		label var ifp_value "Actual value of IFP based on reported fequency of cc repayments (from ccrepay)"
		
		* Step 4: Interest paid
		*********************
		gen r`i'= rate`i'/ccmainrate if ccmainrate!=.
		* Ratio of alternative card interest rate to actual card's rate. We can use this to get an estimate of the value of interest the respondent would pay if they had a different interest rate. 
		gen interest_paid =0 if q7b!=-2 & q7f!=-2
		replace interest_paid = q7f * interest_freq * r`i' if q7f>=0

		
		* Step 4.5: Net value of borrowing function
		********************
		gen netborrowingvalue = ifp_value - interest_paid

		* STEP 5: put everything together
		********
		gen netbenefit`i'= netpmtfunction + netborrowingvalue
		drop rewards_annualval netpmtfunction ifp_potential ifp_value netborrowingvalue interest_paid
	
	}

egen nboptimal = rowmax(netbenefit0 netbenefit1 netbenefit2 netbenefit3 netbenefit4 netbenefit5 netbenefit6 netbenefit7 netbenefit8 netbenefit9 netbenefit10 netbenefit11 netbenefit12 netbenefit13 netbenefit14 netbenefit15 netbenefit16 netbenefit17 netbenefit18)
replace nboptimal = . if netbenefit0==.

* Potential gain from switching to optimal card
gen optimalactual = netbenefit0-nboptimal
}
table notswitching if idtag==1 [pw=w1], c(median optimalactual median netbenefit1111)
